#!/usr/bin/env python2
#
# Copyright (c) 2016,2018 Cisco and/or its affiliates.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from string import Template

from jvpp_model import is_request, is_dump, is_control_ping, is_control_ping_reply


def generate_callbacks(work_dir, model, logger):
    json_api_files = model.json_api_files
    logger.debug("Generating Callback interfaces for %s" % json_api_files)
    plugin_package = model.plugin_package

    callbacks = []
    for msg in model.messages:
        name = msg.java_name_upper
        if is_control_ping(msg) or is_control_ping_reply(msg):
            # Skip control_ping managed by jvpp registry.
            continue
        if is_dump(msg) or is_request(msg):
            continue

        callbacks.append("%s.callback.%sCallback" % (plugin_package, name))
        callback = _CALLBACK_TEMPLATE.substitute(
            plugin_package=plugin_package,
            json_filename=json_api_files,
            name=name)

        with open("%s/%sCallback.java" % (work_dir, name), "w") as f:
            f.write(callback)

    plugin_name = model.plugin_java_name
    with open("%s/JVpp%sGlobalCallback.java" % (work_dir, plugin_name), "w") as f:
        f.write(_GLOBAL_CALLBACK_TEMPLATE.substitute(
            plugin_package=plugin_package,
            json_filename=json_api_files,
            plugin_name=plugin_name,
            callbacks=", ".join(callbacks)
        ))

_CALLBACK_TEMPLATE = Template("""package $plugin_package.callback;

/**
 * <p>Represents callback for plugin's api message.
 * <br>It was generated by jvppgen/callback_gen.py based on $json_filename.
 */
public interface ${name}Callback extends io.fd.vpp.jvpp.callback.JVppCallback {

    void on${name}(${plugin_package}.dto.${name} reply);
}
""")

_GLOBAL_CALLBACK_TEMPLATE = Template("""package $plugin_package.callback;

/**
 * <p>Global aggregated callback interface.
 * <br>It was generated by jvppgen/callback_gen.py based on $json_filename.
 */
public interface JVpp${plugin_name}GlobalCallback extends io.fd.vpp.jvpp.callback.ControlPingCallback, $callbacks {
}
""")
