#!/usr/bin/env python2
#
# Copyright (c) 2016,2018 Cisco and/or its affiliates.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from string import Template

from jvpp_common_gen import generate_hash_code, generate_equals, generate_to_string, generate_fields
from jvpp_model import Class


def generate_types(work_dir, model, logger):
    logger.debug("Generating custom types for %s " % model.json_api_files)

    for t in model.types:
        if not isinstance(t, Class):
            continue
        logger.debug("Generating DTO for type %s", t)
        type_class_name = t.java_name
        fields = t.fields
        type_class = _TYPE_TEMPLATE.substitute(
            plugin_package=model.plugin_package,
            c_type_name=t.name,
            json_filename=model.json_api_files,
            json_definition=t.doc,
            java_type_name=type_class_name,
            fields=generate_fields(fields),
            hash_code=generate_hash_code(fields),
            equals=generate_equals(type_class_name, fields),
            to_string=generate_to_string(type_class_name, fields)
        )
        with open("%s/%s.java" % (work_dir, type_class_name), "w") as f:
            f.write(type_class)

_TYPE_TEMPLATE = Template("""
package $plugin_package.types;

/**
 * <p>This class represents $c_type_name type definition.
 * <br>It was generated by jvpp_types_gen.py based on $json_filename:
 * <pre>
$json_definition
 * </pre>
 */
public final class $java_type_name {
$fields
$hash_code
$equals
$to_string
}
""")
