/*
 * Copyright (c) 2017 Cisco and/or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "vom/bridge_domain_cmds.hpp"

DEFINE_VAPI_MSG_IDS_L2_API_JSON;

namespace VOM {
namespace bridge_domain_cmds {
create_cmd::create_cmd(HW::item<uint32_t>& item,
                       const bridge_domain::learning_mode_t& lmode,
                       const bridge_domain::arp_term_mode_t& amode,
                       const bridge_domain::flood_mode_t& fmode,
                       const bridge_domain::mac_age_mode_t& mmode)
  : rpc_cmd(item)
  , m_learning_mode(lmode)
  , m_arp_term_mode(amode)
  , m_flood_mode(fmode)
  , m_mac_age_mode(mmode)
{
}

bool
create_cmd::operator==(const create_cmd& other) const
{
  return (m_hw_item.data() == other.m_hw_item.data());
}

rc_t
create_cmd::issue(connection& con)
{
  msg_t req(con.ctx(), std::ref(*this));

  auto& payload = req.get_request().get_payload();
  payload.bd_id = m_hw_item.data();
  payload.flood = m_flood_mode.value();
  payload.uu_flood = m_flood_mode.value();
  payload.forward = 1;
  payload.learn = m_learning_mode.value();
  payload.arp_term = m_arp_term_mode.value();
  payload.mac_age = m_mac_age_mode.value();
  payload.is_add = 1;

  VAPI_CALL(req.execute());

  return (wait());
}

std::string
create_cmd::to_string() const
{
  std::ostringstream s;
  s << "bridge-domain-create: " << m_hw_item.to_string();

  return (s.str());
}

delete_cmd::delete_cmd(HW::item<uint32_t>& item)
  : rpc_cmd(item)
{
}

bool
delete_cmd::operator==(const delete_cmd& other) const
{
  return (m_hw_item == other.m_hw_item);
}

rc_t
delete_cmd::issue(connection& con)
{
  msg_t req(con.ctx(), std::ref(*this));

  auto& payload = req.get_request().get_payload();
  payload.bd_id = m_hw_item.data();
  payload.is_add = 0;

  VAPI_CALL(req.execute());

  wait();
  m_hw_item.set(rc_t::NOOP);

  return (rc_t::OK);
}

std::string
delete_cmd::to_string() const
{
  std::ostringstream s;
  s << "bridge-domain-delete: " << m_hw_item.to_string();

  return (s.str());
}

dump_cmd::dump_cmd()
{
}

bool
dump_cmd::operator==(const dump_cmd& other) const
{
  return (true);
}

rc_t
dump_cmd::issue(connection& con)
{
  m_dump.reset(new msg_t(con.ctx(), std::ref(*this)));

  auto& payload = m_dump->get_request().get_payload();
  payload.bd_id = ~0;

  VAPI_CALL(m_dump->execute());

  wait();

  return rc_t::OK;
}

std::string
dump_cmd::to_string() const
{
  return ("bridge-domain-dump");
}
}
}

/*
 * fd.io coding-style-patch-verification: ON
 *
 * Local Variables:
 * eval: (c-set-style "mozilla")
 * End:
 */
